import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:razinsoft_rider/core/utils/exit_app_dialogue.dart';
import 'package:razinsoft_rider/gen/assets.gen.dart';
import 'package:razinsoft_rider/presentation/account_page/provider/country_list_provider.dart';
import 'package:razinsoft_rider/presentation/booking/provider/order_providers.dart';

class SplashPage extends ConsumerStatefulWidget {
  const SplashPage({super.key});

  @override
  ConsumerState<SplashPage> createState() => _SplashPageState();
}

class _SplashPageState extends ConsumerState<SplashPage> {
  final ValueNotifier<Size> logoSize = ValueNotifier(const Size(70, 50));

  @override
  void initState() {
    super.initState();

    Future.microtask(()=> ref.read(countryListProvider.notifier).getCountryList());
    _startAnimation();
  }

  Future<void> _startAnimation() async {
    await Future.delayed(const Duration(milliseconds: 300));
    logoSize.value = const Size(207, 160);

    await Future.delayed(const Duration(seconds: 2));
    Future.microtask(() {
      ref.read(tripActivityNotifierProvider.notifier).checkTripActivity();
    });
  }

  void _resetLogoSize() {
    logoSize.value = const Size(70, 50);
  }

  @override
  Widget build(BuildContext context) => ExitAppWrapper(
      onExit: () {
        logoSize.dispose();
      },
      child: Scaffold(
        body: ref
            .watch(tripActivityNotifierProvider)
            .when(
              initial: () => _body(),
              loading: () => _body(),
              success: (d) {
                _resetLogoSize();
                return _body();
              },
              error: (e) => _body(),
            ),
      ),
    );

  Widget _body() => Stack(
      children: [
        Positioned.fill(child: _animatedLogo()),
        Align(
          alignment: Alignment.bottomCenter,
          child: SizedBox(
            height: MediaQuery.of(context).size.height / 3,
            width: double.infinity,
            child: Assets.images.splashBackground.image(fit: BoxFit.fill),
          ),
        ),
      ],
    );

  Widget _animatedLogo() => Center(
      child: ValueListenableBuilder<Size>(
        valueListenable: logoSize,
        builder: (context, size, _) => AnimatedContainer(
            duration: const Duration(milliseconds: 800),
            curve: Curves.easeInOut,
            width: size.width,
            height: size.height,
            child: Assets.images.appLogo.image(fit: BoxFit.contain),
          ),
      ),
    );
}
